
unit WebForm4;

interface

uses
  SysUtils, System.Web.Security, System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm4 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
		procedure LoginBtn_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		TopHolder: System.Web.UI.WebControls.PlaceHolder;
		CategoriesHolder: System.Web.UI.WebControls.PlaceHolder;
		topicHeading: System.Web.UI.WebControls.Label;
		topicDescription: System.Web.UI.WebControls.Label;
		lblMessage: System.Web.UI.WebControls.Label;
		email: System.Web.UI.WebControls.TextBox;
		emailRequired: System.Web.UI.WebControls.RequiredFieldValidator;
		emailValid: System.Web.UI.WebControls.RegularExpressionValidator;
		password: System.Web.UI.WebControls.TextBox;
		passwordRequired: System.Web.UI.WebControls.RequiredFieldValidator;
		RememberLogin: System.Web.UI.WebControls.CheckBox;
		LoginBtn: System.Web.UI.WebControls.Button;
    procedure OnInit(e: EventArgs); override;
  end;

implementation
uses top, apptypes, developersDB;

var _top : CSTop;
    _AppTypes : csAppTypes;

procedure TWebForm4.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // Put user code to initialize the page here
  topicHeading.Text:='Login to Octane Web Examples';
	topicDescription.Text:='if you want to add your example, please first login...';
end;

procedure TWebForm4.OnInit(e: EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;
  inherited OnInit(e);

      _AppTypes := csAppTypes.create;
      CategoriesHolder.Controls.Add(_AppTypes);
      _AppTypes.Free;

      _top := CSTop.create;
      TopHolder.Controls.Add(_top);
      _top.Free;
end;

procedure TWebForm4.LoginBtn_Click(sender: System.Object; e: System.EventArgs);
var
  Developer          : TdevelopersDB;
  MyDeveloperDetails : DeveloperDetails;
  DeveloperID        : integer;
  kuky               : HttpCookie;
begin
  if not Page.IsValid then Exit;

  Developer := TdevelopersDB.create;
  DeveloperID := developer.Login(email.Text, password.Text);

  if DeveloperID <> 0 then
  begin
   myDeveloperDetails := DeveloperDetails.Create;
    myDeveloperDetails := Developer.GetDeveloperDetails(DeveloperID);

    kuky:=HttpCookie.create('owe_name');
    kuky.Value:=myDeveloperDetails.Name;

    if RememberLogin.Checked = true then
      kuky.Expires := DateTime.FromOADate(IncMonth(Date,1));

    Response.Cookies.Add(kuky);

    kuky.Free;
    
    // Redirect browser back to originating page
    FormsAuthentication.RedirectFromLoginPage(IntToStr(DeveloperID), RememberLogin.Checked);
  end
  else
    lblMessage.Text := 'Login FAILED! Wrong email / password.';

end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm4.InitializeComponent;
begin
	Include(Self.LoginBtn.Click, Self.LoginBtn_Click);
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.

